---
title: Automatic request headers · Cloudflare Browser Rendering docs
description: Cloudflare automatically attaches headers to every REST API request
  made through Browser Rendering. These headers make it easy for destination
  servers to identify that these requests came from Cloudflare.
lastUpdated: 2025-11-06T19:08:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/browser-rendering/reference/automatic-request-headers/
  md: https://developers.cloudflare.com/browser-rendering/reference/automatic-request-headers/index.md
---

Cloudflare automatically attaches headers to every [REST API](https://developers.cloudflare.com/browser-rendering/rest-api/) request made through Browser Rendering. These headers make it easy for destination servers to identify that these requests came from Cloudflare.

Note

These headers are meant to ensure transparency and cannot be removed or overridden (with `setExtraHTTPHeaders`, for example).

| Header | Description |
| - | - |
| `cf-brapi-request-id` | A unique identifier for the Browser Rendering request when using the [REST API](https://developers.cloudflare.com/browser-rendering/rest-api/) |
| `cf-brapi-devtools` | A unique identifier for the Browser Rendering request when using [Workers Bindings](https://developers.cloudflare.com/browser-rendering/workers-bindings/) |
| `cf-biso-devtools` | A flag indicating the request originated from Cloudflare's rendering infrastructure |
| `Signature-agent` | [The location of the bot public keys](https://web-bot-auth.cloudflare-browser-rendering-085.workers.dev), used to sign the request and verify it came from Cloudflare |
| `Signature` and `Signature-input` | A digital signature, used to validate requests, as shown in [this architecture document](https://datatracker.ietf.org/doc/html/draft-meunier-web-bot-auth-architecture) |

The `Signature` headers use an authentication method called [Web Bot Auth](https://developers.cloudflare.com/bots/reference/bot-verification/web-bot-auth/). Web Bot Auth leverages cryptographic signatures in HTTP messages to verify that a request comes from an automated bot. To verify a request originated from Cloudflare Browser Rendering, use the keys found on [this directory](https://web-bot-auth.cloudflare-browser-rendering-085.workers.dev/.well-known/http-message-signatures-directory) to verify the `Signature` and `Signature-Input` found in the headers from the incoming request. A successful verification proves that the request originated from Cloudflare Browser Rendering and has not been tampered with in transit.
