---
title: Cannot verify a domain with CNAME · Cloudflare DNS docs
description: "When configuring services from external providers - such as email
  services, for example - it is possible that they require you to verify your
  domain by placing a CNAME record at your zone, similar to the following:"
lastUpdated: 2025-09-19T15:07:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/manage-dns-records/troubleshooting/cname-domain-verification/
  md: https://developers.cloudflare.com/dns/manage-dns-records/troubleshooting/cname-domain-verification/index.md
---

When configuring services from external providers - such as email services, for example - it is possible that they require you to verify your domain by placing a CNAME record at your zone, similar to the following:

```plaintext
<value>._domainkey.example.com CNAME <hostname>.<service provider domain>
```

Consider the sections below if this is not working correctly for you.

## Causes

You may find issues if you have one of the following:

* The CNAME record you created for domain verification is set to [**Proxied**](https://developers.cloudflare.com/dns/proxy-status/).
* The CNAME record is correctly set to DNS only (not proxied) but, in your [zone settings](https://dash.cloudflare.com/?to=/:account/:zone/dns/settings), [**CNAME flattening for all CNAME records**](https://developers.cloudflare.com/dns/cname-flattening/set-up-cname-flattening/#for-all-cname-records) is enabled.
* The CNAME record is correctly set to DNS only (not proxied) but CNAME flattening is [enabled for that record specifically](https://developers.cloudflare.com/dns/cname-flattening/set-up-cname-flattening/#per-record).
* An [NS record](https://www.cloudflare.com/learning/dns/dns-records/dns-ns-record/) exists, causing a different DNS provider to be authoritative for the subdomain.

## Solution

Make sure that:

* In your zone DNS settings: [**CNAME flattening for all CNAME records**](https://developers.cloudflare.com/dns/cname-flattening/) is disabled.

* On the DNS records table: you have filled in the CNAME record fields correctly, proxy status is set to **DNS only**, and **Flatten** is disabled.

* You have the correct NS configuration, and either:

  * Make sure that the CNAME record is set as expected with the DNS provider that the NS record points to.
  * Review your configuration for other DNS records that may be affected by the NS record. Once you are aware of any consequences or have made any necessary adjustments, remove the NS record so that the CNAME is resolved to the target you configured on Cloudflare.
