---
title: API deprecations · Cloudflare Fundamentals docs
description: Cloudflare occasionally makes updates to our APIs that result in
  behavior changes or deprecations. When this happens, we will communicate when
  the API will no longer be available and whether there will be a replacement.
lastUpdated: 2025-05-05T16:36:12.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/api/reference/deprecations/
  md: https://developers.cloudflare.com/fundamentals/api/reference/deprecations/index.md
---

Cloudflare occasionally makes updates to our APIs that result in behavior changes or deprecations. When this happens, we will communicate when the API will no longer be available and whether there will be a replacement.

Note

Subscribe to all API deprecation posts via [RSS](https://developers.cloudflare.com/fundamentals/api/reference/deprecations/index.xml).

[Subscribe to RSS](https://developers.cloudflare.com/fundamentals/api/reference/deprecations/index.xml)

## 2025-11-11

**Zero Trust Devices**

End of life date: November 11, 2025

We are changing the definition of Devices. Devices are going to represent the real-world machines while the relation between Users and Devices will be represented by a new concept - Registrations.

As a result multiple fields are moving from Devices to Registrations and we are deprecating the endpoints listed below.

The deprecated endpoints are not supported on accounts with [multi-user mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/mdm-deployment/windows-multiuser/) enabled.

Deprecated API:

* `GET /accounts/{account_id}/devices`
* `GET /accounts/{account_id}/devices/{device_id}`
* `GET /accounts/{account_id}/devices/{device_id}/override_codes`
* `POST /accounts/{account_id}/devices/revoke`
* `POST /accounts/{account_id}/devices/unrevoke`

Replacement:

* `GET /accounts/{account_id}/devices/physical-devices`
* `GET /accounts/{account_id}/devices/physical-devices/{device_id}`
* `GET /accounts/{account_id}/devices/registrations`
* `GET /accounts/{account_id}/devices/registrations/{registration_id}`
* `GET /accounts/{account_id}/devices/registrations/{registration_id}/override_codes`
* `POST /accounts/{account_id}/devices/registrations/revoke`
* `POST /accounts/{account_id}/devices/registrations/unrevoke`

## 2025-11-03

**Cloudflare Mirage**

Deprecation date: November 2025

End of life date: January 2026

Following on from the [deprecation of Cloudflare Mirage](https://developers.cloudflare.com/speed/optimization/images/mirage/), the following API endpoints that manage Mirage settings are now deprecated and will be sunsetted in January 2026.

Deprecated APIs:

* `GET /zones/{zone_id}/settings/mirage`
* `PATCH /zones/{zone_id}/settings/mirage`

Affected APIs:

* `GET /zones/{zone_id}/pagerules/settings` - Mirage will be removed from available settings.
* `POST /zones/{zone_id}/pagerules` - Mirage parameter will be removed.
* `PATCH /zones/{zone_id}/pagerules/{rule_id}` - Mirage parameter will be removed.
* `PUT /zones/{zone_id}/pagerules/{rule_id}` - Mirage parameter will be removed.
* `GET /zones/{zone_id}/rulesets/{ruleset_id}` - Mirage parameter in `set_config` action will be removed.
* `GET /zones/{zone_id}/rulesets/{ruleset_id}/versions/{version_id}` - Mirage parameter in `set_config` action will be removed.
* `POST /zones/{zone_id}/rulesets` - Mirage parameter in `set_config` action will be removed.
* `PUT /zones/{zone_id}/rulesets/{ruleset_id}` - Mirage parameter in `set_config` action will be removed.
* `POST /zones/{zone_id}/rulesets/{ruleset_id}/rules` - Mirage parameter in `set_config` action will be removed.
* `PATCH /zones/{zone_id}/rulesets/{ruleset_id}/rules/{rule_id}` - Mirage parameter in `set_config` action will be removed.
* `GET /accounts/{account_id}/rulesets/{ruleset_id}` - Mirage parameter in `set_config` action will be removed.
* `GET /accounts/{account_id}/rulesets/{ruleset_id}/versions/{version_id}` - Mirage parameter in `set_config` action will be removed.
* `POST /accounts/{account_id}/rulesets` - Mirage parameter in `set_config` action will be removed.
* `PUT /accounts/{account_id}/rulesets/{ruleset_id}` - Mirage parameter in `set_config` action will be removed.
* `POST /accounts/{account_id}/rulesets/{ruleset_id}/rules` - Mirage parameter in `set_config` action will be removed.
* `PATCH /accounts/{account_id}/rulesets/{ruleset_id}/rules/{rule_id}` - Mirage parameter in `set_config` action will be removed.

## 2025-10-15

**Cloudflare Radar: Summary and Timeseries Groups Endpoints**

Deprecation date: October 15, 2025

End of life date: April 15, 2026

The Radar API currently has multiple summary and timeseries groups endpoints per dataset (for example, `/radar/http/summary/device_type` and `/radar/http/timeseries_groups/device_type`), which share nearly identical parameters and schema. To simplify the API and improve maintainability, these endpoints will be replaced with parameterized endpoints using a `{dimension}` path parameter.

Deprecated APIs:

* `GET /radar/http/summary/device_type`
* `GET /radar/http/summary/bot_class`
* `GET /radar/http/timeseries_groups/device_type`
* `GET /radar/http/timeseries_groups/bot_class`
* Other similar summary and timeseries groups endpoints for the following datasets: AI Bots, AI Inference, AS112, DNS, Email Routing, Email security, HTTP, Layer 3 Attacks, Layer 7 Attacks, Leaked Credential Checks

Replacements:

* `GET /radar/http/summary/{dimension}`
* `GET /radar/http/timeseries_groups/{dimension}`
* ...

Here, `{dimension}` is a required path parameter listing all available dimensions for the dataset.

For users calling the API directly (not via the Cloudflare SDK), no action is required. For users using the SDK, we recommend updating to the new operations to ensure compatibility after the operations are removed.

## 2025-07-01

**Cloudflare Radar: Verified Bots APIs**

Deprecation date: July 1, 2025

End of life date: January 1, 2026

The Radar Verified Bots API is now deprecated and will be replaced by the new Bots API.

Deprecated APIs:

* `GET /radar/verified_bots/top/bots`
* `GET /radar/verified_bots/top/categories`

Replacements:

* `GET /radar/bots/summary/bot`
* `GET /radar/bots/summary/category`

## 2025-07-01

**Cloudflare DWeb Resolver**

Deprecation date: July 1, 2025

The Cloudflare DWeb Resolver experiment is ending.

Deprecated APIs:

* DoH resolver on resolver.cloudflare-eth.com

## 2025-06-15

**Firewall Rules API and Filters API**

Deprecation date: June 15, 2025

The Firewall Rules API and the Filters API are deprecated, since Firewall Rules was deprecated in favor of [WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/). Refer to [Firewall Rules upgrade](https://developers.cloudflare.com/waf/reference/legacy/firewall-rules-upgrade/) for more information about this change.

Deprecated APIs:

* `GET /zones/:zone_id/firewall/rules`
* `POST /zones/:zone_id/firewall/rules`
* `PATCH /zones/:zone_id/firewall/rules`
* `PUT /zones/:zone_id/firewall/rules`
* `DELETE /zones/:zone_id/firewall/rules`
* `GET /zones/:zone_id/firewall/rules/:rule_id`
* `PATCH /zones/:zone_id/firewall/rules/:rule_id`
* `PUT /zones/:zone_id/firewall/rules/:rule_id`
* `DELETE /zones/:zone_id/firewall/rules/:rule_id`
* `GET /zones/:zone_id/filters`
* `POST /zones/:zone_id/filters`
* `PUT /zones/:zone_id/filters`
* `DELETE /zones/:zone_id/filters`
* `GET /zones/:zone_id/filters/:filter_id`
* `PUT /zones/:zone_id/filters/:filter_id`
* `DELETE /zones/:zone_id/filters/:filter_id`

Replacement: [WAF custom rules](https://developers.cloudflare.com/waf/custom-rules/)

## 2025-06-15

**WAF managed rules APIs (previous version)**

Deprecation date: June 15, 2025

The APIs for managing WAF managed rules (previous version) — namely for managing packages, rule groups, rules, and overrides — are deprecated in favor of using the [Rulesets API](https://developers.cloudflare.com/ruleset-engine/rulesets-api/) for managing the new version of [WAF Managed Rules](https://developers.cloudflare.com/waf/managed-rules/). Refer to [WAF Managed Rules upgrade](https://developers.cloudflare.com/waf/reference/legacy/old-waf-managed-rules/upgrade/) for more information about this change.

Deprecated APIs:

* `GET /zones/:zone_id/firewall/waf/packages`
* `GET /zones/:zone_id/firewall/waf/packages/:package_id`
* `PATCH /zones/:zone_id/firewall/waf/packages/:package_id`
* `GET /zones/:zone_id/firewall/waf/packages/:package_id/groups`
* `GET /zones/:zone_id/firewall/waf/packages/:package_id/groups/:group_id`
* `PATCH /zones/:zone_id/firewall/waf/packages/:package_id/groups/:group_id`
* `GET /zones/:zone_id/firewall/waf/packages/:package_id/rules`
* `GET /zones/:zone_id/firewall/waf/packages/:package_id/rules/:rule_id`
* `PATCH /zones/:zone_id/firewall/waf/packages/:package_id/rules/:rule_id`
* `GET /zones/:zone_id/firewall/waf/overrides`
* `POST /zones/:zone_id/firewall/waf/overrides`
* `GET /zones/:zone_id/firewall/waf/overrides/:override_id`
* `PUT /zones/:zone_id/firewall/waf/overrides/:override_id`
* `DELETE /zones/:zone_id/firewall/waf/overrides/:override_id`

Replacement: [WAF Managed Rules](https://developers.cloudflare.com/waf/managed-rules/) (new version)

## 2025-06-15

**Rate Limiting API (previous version)**

Deprecation date: June 15, 2025

The Rate Limiting API is deprecated, in favor of using the [Rulesets API](https://developers.cloudflare.com/ruleset-engine/rulesets-api/) for managing the new [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/). Refer to [Rate limiting (previous version) upgrade](https://developers.cloudflare.com/waf/reference/legacy/old-rate-limiting/upgrade/) for more information about this change.

Deprecated API:

* `GET /zones/:zone_id/rate_limits`
* `POST /zones/:zone_id/rate_limits`
* `GET /zones/:zone_id/rate_limits/:rate_limit_id`
* `PUT /zones/:zone_id/rate_limits/:rate_limit_id`
* `DELETE /zones/:zone_id/rate_limits/:rate_limit_id`

Replacement: [Rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/) (new version)

## 2025-06-08

**Zone Setting: cname\_flattening**

Deprecation date: June 8, 2025

The Zone Settings API endpoints for managing zone-level CNAME flattening are deprecated. Instead, use the [Show DNS Settings](https://developers.cloudflare.com/api/resources/dns/subresources/settings/subresources/zone/methods/get/) and [Update DNS Settings](https://developers.cloudflare.com/api/resources/dns/subresources/settings/subresources/zone/methods/edit/) endpoints to manage this setting.

Changes via the old endpoints will be reflected in the new ones, and vice versa, so there is no need to migrate existing zones. However, future API calls must use DNS Settings instead of the Zone Settings endpoints.

Note that, with the deprecated zone setting, values `"off"` and `"apex"` have the same behavior. These are represented as `{"flatten_all_cnames": false}` in the new API. The zone setting `"on"` corresponds to `{"flatten_all_cnames": true}` in the new API.

Affected APIs:

* `GET /zones/:zone_id/settings`
* `PATCH /zones/:zone_id/settings`

Deprecated APIs:

* `GET /zones/:zone_id/settings/cname_flattening`
* `PATCH /zones/:zone_id/settings/cname_flattening`

## 2025-03-23

**Eligible Zones For Account Custom Nameservers**

Deprecation date: March 23, 2025

Users can now add custom nameservers that are not part of a zone managed within their account. As a result, any zone is eligible for custom nameservers, regardless of whether it is managed by Cloudflare. Given this change, an endpoint to check for eligible zones is no longer relevant and is therefore being deprecated.

Deprecated APIs:

* `GET /accounts/:account_id/custom_ns/availability`

## 2025-03-20

**Cloudflare Radar: Attack top industry and vertical endpoints**

Deprecation date: March 20, 2025

End of life date: September 20, 2025

The `/top/industry` and `/top/vertical` attack endpoints are now deprecated and will be replaced by the corresponding summary endpoints.

Affected APIs:

* `GET /radar/attacks/layer3/top/industry`
* `GET /radar/attacks/layer3/top/vertical`
* `GET /radar/attacks/layer7/top/industry`
* `GET /radar/attacks/layer7/top/vertical`

Replacements:

* `GET /radar/attacks/layer3/summary/industry`
* `GET /radar/attacks/layer3/summary/vertical`
* `GET /radar/attacks/layer7/summary/industry`
* `GET /radar/attacks/layer7/summary/vertical`

## 2025-03-17

**Security Center: Security level and Threat Score are now automated**

Change date: March 17, 2025

Cloudflare now combines the IP address threat signal with threshold and botnet data, no longer requiring you to set a sensitivity level. Users will no longer be able to set Security level via the Cloudflare dashboard. However, users can still rely on the existing API or Terraform configuration to set a Security level.

If you are using threat score in rule expressions, you should review those expressions to make sure the rule still triggers when appropriate. Cloudflare will audit and migrate your configuration in the future to update any references to threat score. If you are using the Rulesets API or Terraform to push your configuration, you should review your scripts and pipelines before the end of Q1 2026 to prevent issues.

## 2025-03-14

**Account Settings: default\_nameservers and use\_account\_custom\_ns\_by\_default**

Deprecation date: March 14, 2025

The fields `"default_nameservers"` and `"use_account_custom_ns_by_default"` within the `"settings"` object of accounts are deprecated. Instead, use the [Show DNS Settings](https://developers.cloudflare.com/api/resources/dns/subresources/settings/subresources/account/methods/get/) and [Update DNS Settings](https://developers.cloudflare.com/api/resources/dns/subresources/settings/subresources/account/methods/edit/) endpoints to manage this setting. This setting is available in the new API as `.zone_defaults.nameservers.type`, with allowed values `"cloudflare.standard"`, `"cloudflare.standard.random"`, `"custom.account"` and `"custom.tenant"`.

Changes via the old endpoints will be reflected in the new ones, and vice versa, so there is no need to migrate existing zones. However, future API calls must use DNS Settings instead of the Accounts endpoints.

Affected APIs:

* `GET /accounts`
* `POST /accounts`
* `GET /accounts/:account_id`
* `PUT /accounts/:account_id`

## 2025-03-11

**Cloudflare Radar: Layer 7 attack magnitude parameter**

Deprecation date: March 11, 2025

End of life date: June 11, 2025

The layer 7 attack `magnitude` query parameter, which allows you to define attack magnitude by total requests mitigated (`MITIGATED_REQUESTS`) or total zones attacked (`AFFECTED_ZONES`), is deprecated. Moving forward, Cloudflare Radar will only support defining layer 7 attack magnitude based on the total number of mitigated requests.

Affected API:

`GET /radar/attacks/layer7/top/attacks`

Replacement:

Users should stop using the `magnitude` parameter, as the default behavior already uses `MITIGATED_REQUESTS`.

## 2025-02-21

**DNS Records API: Changes to Filter Parameters**

Deprecation date: February 21, 2025

The following URL parameters for filtering DNS records are deprecated:

* `name=contains:value` Instead, use the supported `name.contains=value` syntax.
* `name=starts_with:value` Instead, use the supported `name.startswith=value` syntax.
* `name=ends_with:value` Instead, use the supported `name.endswith=value` syntax.
* `name=one,two,three` (searching for one of multiple possible names, separated by commas) Instead, make multiple requests, one for each possible `name`. Alternatively, if only querying the `name` field, the `?match=any&name=one&name=two&name=three` syntax can be used instead. This syntax has an extended deprecation date of May 23, 2025.
* `content=contains:value` Instead, use the supported `content.contains=value` syntax.
* `content=starts_with:value` Instead, use the supported `content.startswith=value` syntax.
* `content=ends_with:value` Instead, use the supported `content.endswith=value` syntax.
* `content=one,two,three` (searching for one of multiple possible contents, separated by commas) Instead, make multiple requests, one for each possible `content`. Alternatively, if only querying the `content` field, the `?match=any&content=one&content=two&content=three` syntax can be used instead. This syntax has an extended deprecation date of May 23, 2025.
* `type=contains:value` Searching for substrings of a type name will no longer be supported. Instead, please search for an exact type name, such as `type=CNAME`. If the input value is a free-text search from a human user, consider using the `search` parameter instead.

None of the parameters being deprecated were ever officially supported per our API documentation.

Affected APIs:

* `GET /zones/:zone_id/dns_records`

## 2024-12-09

**Access applications: self\_hosted\_domains**

Deprecation date: November 21, 2025

The `self_hosted_domains` field for [Access applications](https://developers.cloudflare.com/api/resources/zero_trust/subresources/access/subresources/applications/methods/update/) is deprecated in favor of `destinations` to allow for more flexibility in defining different types of domains.

Before:

```json
{
  // ...
  "self_hosted_domains": ["foo.example.com", "bar.example.com"]
}
```

After:

```json
{
  // ...
  "destinations": [
    {
      "type": "public",
      "uri": "foo.example.com"
    },
    {
      "type": "public",
      "uri": "bar.example.com"
    }
  ]
}
```

The API will accept both fields until the deprecation date. If `self_hosted_domains` are provided, then they will be interpreted as `public` destinations. However, if `destinations` are provided, then `self_hosted_domains` will be ignored even if provided.

Additionally, the API will continue to return `self_hosted_domains` until the deprecation date. The field will contain the URIs of the subset of destinations that have type `public`.

Affected APIs:

* `GET /accounts/:account_id/access/apps`
* `POST /accounts/:account_id/access/apps`
* `GET /accounts/:account_id/access/apps/:app_id`
* `PUT /accounts/:account_id/access/apps/:app_id`
* `GET /zones/:zone_id/access/apps`
* `POST /zones/:zone_id/access/apps`
* `GET /zones/:zone_id/access/apps/:app_id`
* `PUT /zones/:zone_id/access/apps/:app_id`

## 2024-11-30

**Zone information in individual DNS records**

Deprecation date: November 30, 2024

Currently, each individual DNS record returned by the API contains information about the zone it is on, specifically the zone ID and name.

```json
{
  "result": [
    {
      // ...
      "zone_id": "ab922473c42f4e50819d7c1c9b81b16b",
      "zone_name": "example.com"
    }
  ],
  // ...
}
```

This information is redundant because both affected API routes are already within the zone scope. In particular, the zone ID will already be known to any user of these routes because it appears in the URL. The zone name can be retrieved by making a `GET` request to `/zones/:zone_id` if it is necessary.

After November 30th, 2024, Cloudflare will stop including the `zone_id` and `zone_name` fields on individual DNS records in API responses. These fields are currently ignored when sent to the API as part of a request body, so no changes to request bodies are required.

Modified API:

* `GET /zones/:zone_id/dns_records`
* `POST /zones/:zone_id/dns_records`
* `GET /zones/:zone_id/dns_records/:dns_record_id`
* `PATCH /zones/:zone_id/dns_records/:dns_record_id`
* `PUT /zones/:zone_id/dns_records/:dns_record_id`

## 2024-10-01

**DNS Records: Error chains for DNS validation errors**

Deprecation date: October 1, 2024

Cloudflare is making a minor change to the representation of certain errors when creating DNS records. Currently, when the DNS record to be created is invalid, an error similar to the following may be returned:

```txt
{
  "result": null,
  "success": false,
  "errors": [
    {
      "code": 1004,
      "message": "DNS Validation Error",
      "error_chain": [
        {
          "code": 9999,
          "message": "This is an example."
        }
      ]
    }
  ],
  "messages": []
}
```

After October 1st, 2024, the `error_chain` will be omitted, returning the root cause directly without wrapping it in another "DNS Validation Error" error:

```txt
{
  "result": null,
  "success": false,
  "errors": [
    {
      "code": 9999,
      "message": "This is an example."
    }
  ],
  "messages": []
}
```

## 2024-09-13

**Legacy DNS Settings Endpoints**

Deprecation date: September 13, 2024

The dedicated endpoints for DNS settings `use_apex_ns` and `secondary_overrides` are being deprecated.

Instead, use the [Show DNS Settings](https://developers.cloudflare.com/api/resources/dns/subresources/settings/subresources/zone/methods/get/) and [Update DNS Settings](https://developers.cloudflare.com/api/resources/dns/subresources/settings/subresources/zone/methods/edit/) endpoints to manage these settings.

* Instead of the `.../use_apex_ns` endpoint, use the `multi_provider` field.
* Instead of the `.../secondary_overrides` endpoint, use the `secondary_overrides` field.

Deprecated APIs:

* `GET /zones/:zone_id/dns_settings/use_apex_ns`
* `PATCH /zones/:zone_id/dns_settings/use_apex_ns`
* `GET /zones/:zone_id/dns_settings/secondary_overrides`
* `PATCH /zones/:zone_id/dns_settings/secondary_overrides`

## 2024-08-15

**Brotli**

Deprecation date: August 15, 2024

The Brotli setting and its API endpoints are deprecated. Brotli compression is available for all non-Enterprise zones, and it will be extended to Enterprise zones in the coming year.

Deprecated APIs:

* `GET /zones/:zone_id/settings/brotli`
* `PATCH /zones/:zone_id/settings/brotli`

Enterprise customers can override Cloudflare's default compression behavior using [Compression Rules](https://developers.cloudflare.com/rules/compression-rules/).

## 2024-08-05

**Auto Minify**

Deprecation date: August 5, 2024

The Auto Minify API endpoints are deprecated since the Auto Minify feature was deprecated.

Deprecated APIs:

* `GET /zones/:zone_id/settings/minify`
* `PATCH /zones/:zone_id/settings/minify`

## 2024-07-14

**DNS Records: 'locked' Field**

Deprecation date: July 14, 2024

The `"locked"` field of DNS records in API responses is unused and has been guaranteed to always be `false` for more than a year. This deprecation means that the field will be omitted from API responses entirely. If received from a client, the field will continue to be ignored, just as it is today.

Modified API:

* `GET /zones/:zone_id/dns_records`
* `POST /zones/:zone_id/dns_records`
* `GET /zones/:zone_id/dns_records/:dns_record_id`
* `PATCH /zones/:zone_id/dns_records/:dns_record_id`
* `PUT /zones/:zone_id/dns_records/:dns_record_id`

## 2024-06-30

**Mobile redirect**

Deprecation date: June 30, 2024

This endpoint and its related APIs are deprecated in favor of [Single Redirects](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/). Refer to [Perform mobile redirects](https://developers.cloudflare.com/rules/url-forwarding/examples/perform-mobile-redirects/) to migrate Mobile Redirect to Redirect Rules.

Deprecated API:

* `GET /zones/:zone_identifier/settings/mobile_redirect`
* `PATCH /zones/:zone_identifier/settings/mobile_redirect`

Replacement: [Single Redirects](https://developers.cloudflare.com/rules/url-forwarding/single-redirects/)

## 2024-06-14

**Server-side Excludes**

Deprecation date: June 14, 2024

The Server-side Excludes feature and its API endpoints are deprecated.

Deprecated APIs:

* `GET /zones/:zone_id/settings/server_side_exclude`
* `PATCH /zones/:zone_id/settings/server_side_exclude`

## 2024-05-31

**Name-Related Data Fields on SRV (DNS) Records**

Deprecation date: May 31, 2024

The name of an SRV record normally consists of three parts: the service (e.g., `_xmpp`), the protocol (e.g., `_tcp`), and the base name (`example.com`).

The complete name would then be, e.g., `_xmpp._tcp.example.com`.

When interacting with DNS records through the [API](https://developers.cloudflare.com/api/resources/dns/subresources/records/methods/create/), SRV records contain both a full `name` as well as a `data` map containing the individual components of the name:

```txt
{
  "name": "_xmpp._tcp.example.com",
  "data": {
    "service": "_xmpp",
    "proto": "_tcp",
    "name": "example.com",
    ...
  },
  ...
}
```

We are deprecating the `service`, `proto` and `name` fields *within* the `data` map in favor of the `name` field *outside* the data map, which is the same name field that's used by all other record types.

Before the end of life date, please ensure that:

* when reading SRV records, you use only the `name` outside of the data map and ignore `service`, `proto` and `name` within the data map if they exist; and
* when writing SRV records, you set the `name` outside of the data map and **do not set** `service`, `proto` or `name` within the data map.

After the end of life date, the API will stop producing the `service`, `proto` and `name` data fields, and if any of them are received from a client, an error will be returned.

This deprecation does not affect other SRV data fields not mentioned above (`priority`, `weight`, `port`, `target`) or data fields for any other record type other than SRV.

Modified API:

* `GET /zones/:zone_id/dns_records`
* `POST /zones/:zone_id/dns_records`
* `GET /zones/:zone_id/dns_records/:dns_record_id`
* `PATCH /zones/:zone_id/dns_records/:dns_record_id`
* `PUT /zones/:zone_id/dns_records/:dns_record_id`

## 2024-03-31

**Privacy Pass API Removal**

Deprecation date: March 31, 2024

In 2017, Cloudflare [announced support](https://blog.cloudflare.com/cloudflare-supports-privacy-pass/) for Privacy Pass, a recent protocol to let users prove their identity across multiple sites anonymously without enabling tracking. The initial use case was to provide untraceable tokens to sites to vouch for users who might otherwise have been presented with a CAPTCHA challenge. In the time since this release, Privacy Pass has evolved both at the [IETF](https://datatracker.ietf.org/wg/privacypass/documents/) and within Cloudflare. The version announced in 2017 is now considered legacy, and these legacy Privacy Pass tokens are no longer supported as an alternative to Cloudflare challenges. As has been discussed on our blog [The end road for CAPTCHA](https://blog.cloudflare.com/end-cloudflare-captcha/), Cloudflare uses a variety of signals to infer if incoming traffic is likely automated. The (legacy) Privacy Pass zone setting is no longer meaningful to Cloudflare customers as Cloudflare now operates [CAPTCHA free](https://blog.cloudflare.com/turnstile-ga/), and supports the latest [Privacy Pass draft](https://blog.cloudflare.com/eliminating-captchas-on-iphones-and-macs-using-new-standard/).

In September 2023, support for legacy Privacy Pass tokens as an alternative to Cloudflare Managed Challenge was removed. By the end of March 2024, the current public-facing API will be removed as well.

Deprecated API:

* `GET zones/:zone_identifier/settings/privacy_pass`
* `POST zones/:zone_identifier/settings/privacy_pass`

## 2024-02-04

**Argo Tunnel**

Deprecation date: February 4, 2024

This endpoint and its related APIs are deprecated in favor of the Cloudflare Tunnels equivalent APIs.

Deprecated API:

* `GET accounts/:account_identifier/tunnels`
* `POST accounts/:account_identifier/tunnels`
* `GET accounts/:account_identifier/tunnels/:tunnel_id`
* `DELETE accounts/:account_identifier/tunnels/:tunnel_id`

Replacement: Cloudflare Tunnel API

## 2023-07-01

**ChaCha20 TLS Cipher Removal**

Deprecation date: July 1, 2023

Back in 2016, Cloudflare [introduced support](https://blog.cloudflare.com/it-takes-two-to-chacha-poly/) for `ChaCha20-Poly1305` cipher suites for TLS 1.2. At the time, we introduced two variants of these new suites, the "standard" suites as defined by the IETF RFC 7905, and "draft" suites that followed an earlier draft of said specification. The draft suites were added for compatibility with some older Android devices that at the time did not yet support the proper `ChaCha20-Poly1305` standard versions. This was in 2016, and in the meantime the standard `ChaCha20-Poly1305` cipher suites have gained much wider adoption, to the point were traffic using the old suites has dropped significantly. Due to the current low usage and the non-standard nature of these cipher suites, we are now deprecating their support on the Cloudflare network.

This should not affect customer zones in any way, as clients that might currently use these cipher suites will be able to fallback to different ones. In addition, unlike the standard variants, these legacy cipher suites are not exposed directly through our API (e.g. through the TLS cipher suites preferences endpoint), and their deprecation will not affect customer configurations in any way.

As of July 1st, 2023, the ChaCha20-Poly1305 ciphers have been deprecated and are deemed End of Life by Cloudflare. If you have clients that currently rely on these ciphers, it is strongly recommended to upgrade them to newer, more secure ciphers. Be aware that these deprecated ciphers will be completely removed in the first quarter of 2024, and requests using them will start to fail. Take proactive measures to ensure a smooth transition and maintain the security of your systems.

## 2023-07-01

**Transfer-Encoding and Content-Length headers**

Deprecation date: July 1, 2023

Previously, RFC 2616 allowed the use of `Transfer-Encoding` and `Content-Length` HTTP headers in the same request. RFC 7230 supersedes RFC 2616 and prohibits the use of `Transfer-Encoding` and `Content-Length` headers in the same request because they can cause HTTP request smuggling vulnerabilities.

Starting on July 1st, 2023, Cloudflare will decline requests with both `Transfer-Encoding` and `Content-Length` HTTP headers.

## 2023-06-06

**Account Billing Profile, User Billing Profile, and User Billing History**

Deprecation date: June 6, 2023

There is no API replacement for these endpoints. As an alternative, please log in to your Cloudflare account to view your:

* [Invoices & Billing Email](https://dash.cloudflare.com/?to=/:account/billing)
* [Billing subscriptions](https://dash.cloudflare.com/?to=/:account/billing/subscriptions)
* [Billing profile payment info](https://dash.cloudflare.com/?to=/:account/billing/payment-info)

Deprecated API:

* `GET accounts/{account_identifier}/billing/profile`
* `GET user/billing/profile`
* `GET user/billing/history`

## 2023-04-03

**Load Balancing - notification\_email**

Deprecation date: April 3, 2023

This field is deprecated and has been moved to [Cloudflare centralized notification service](https://developers.cloudflare.com/notifications/).

`notification_email` is the email address to send health status notifications to. This can be an individual mailbox or a mailing list. Multiple emails can be supplied as a comma delimited list.

## 2023-03-19

**Access Bookmark applications**

Deprecation date: March 19, 2023

This endpoint is deprecated in favor of using a specialized Access Application App Type API.

Deprecated API:

* `GET accounts/:identifier/access/bookmarks`
* `GET accounts/:identifier/access/bookmarks/:uuid`
* `POST accounts/:identifier/access/bookmarks/:uuid`
* `PUT accounts/:identifier/access/bookmarks/:uuid`
* `DELETE accounts/:identifier/access/bookmarks/:uuid`

Replacement: Access applications app type API

## 2022-10-11

**Page Shield**

Deprecation date: October 11, 2022

Replace `script_monitor` in Page Shield API routes with `page_shield`.

## 2022-07-01

**Cloudflare Images - Create authenticated direct upload URL v1**

Deprecation date: July 1, 2022

This endpoint is deprecated in favor of using v2, which allows you to control metadata, define an access policy, and get the image ID.

Deprecated API: `POST accounts/:account_identifier/images/v1/direct_upload`

Replacement: `POST accounts/:account_identifier/images/v2/direct_upload`

## 2021-03-01

**Zone Analytics API**

Deprecation date: March 1, 2021

This API is deprecated in favor of the [GraphQL Analytics API](https://developers.cloudflare.com/analytics/graphql-api/), which provides equivalent data and more features, including the ability to select only the metrics that you need. For more information, refer to the [Zone analytics to GraphQL analytics migration guide](https://developers.cloudflare.com/analytics/graphql-api/migration-guides/zone-analytics/).

Deprecated API:

* `GET zones/:zone_identifier/analytics/dashboard`
* `GET zones/:zone_identifier/analytics/colos`

Replacement: GraphQL Analytics API

## 2020-04-02

**Organizations**

Deprecation date: April 2, 2020

This endpoint and its related APIs are deprecated in favor of the `/accounts` equivalent API, which has a broader range of features and is backwards compatible with the `/organizations` API.

Deprecated API:

* `GET organizations/:identifier`
* `PATCH organizations/:identifier`
* `GET organizations/:organization_identifier/invites`
* `POST organizations/:organization_identifier/invites`
* `GET organizations/:organization_identifier/invites/:identifier`
* `PATCH organizations/:organization_identifier/invites/:identifier`
* `DELETE organizations/:organization_identifier/invites/:identifier`
* `GET organizations/:organization_identifier/members`
* `GET organizations/:organization_identifier/members/:identifier`
* `PATCH organizations/:organization_identifier/members/:identifier`
* `DELETE organizations/:organization_identifier/members/:identifier`
* `GET organizations/:organization_identifier/roles`
* `GET organizations/:organization_identifier/roles/:identifier`
* `GET organizations/:organization_identifier/audit_logs`
* `GET organizations/:organization_identifier/railguns`
* `POST organizations/:organization_identifier/railguns`
* `GET organizations/:organization_identifier/railguns/:identifier`
* `PATCH organizations/:organization_identifier/railguns/:identifier`
* `DELETE organizations/:organization_identifier/railguns/:identifier`
* `GET organizations/:organization_identifier/railguns/:identifier/zones`

Replacement: Accounts API

## Related resources

* [Available RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/) (for the [Cloudflare changelog](https://developers.cloudflare.com/changelog/))
* [Subscribe to Cloudflare Status](https://developers.cloudflare.com/support/cloudflare-status/)
* [Planned maintenance windows](https://developers.cloudflare.com/support/disruptive-maintenance/)
