---
title: Session timeouts · Cloudflare Learning Paths
description: Most legacy VPNs have a global timeout setting that requires end
  users to log in every X hours or resets VPN profiles at a certain frequency.
  By doing continuous identity evaluation, a Zero Trust security model
  eliminates the need for most of the user-interrupting workflows triggered by
  session timeouts. However, there can still be valid reasons to want users to
  reauthenticate, either on a recurring basis or to access specific,
  highly-sensitive or regulated internal services.
lastUpdated: 2025-02-21T10:05:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/replace-vpn/build-policies/session-timeouts/
  md: https://developers.cloudflare.com/learning-paths/replace-vpn/build-policies/session-timeouts/index.md
---

Most legacy VPNs have a global timeout setting that requires end users to log in every X hours or resets VPN profiles at a certain frequency. By doing continuous identity evaluation, a Zero Trust security model eliminates the need for most of the user-interrupting workflows triggered by session timeouts. However, there can still be valid reasons to want users to reauthenticate, either on a recurring basis or to access specific, highly-sensitive or regulated internal services.

To enforce WARP client reauthentication, you can configure WARP session timeouts on a per-application basis in your Gateway network policies.

When a user goes to a protected application or website, Cloudflare checks their WARP session duration against the configured session timeout. If the session has expired, the user will be prompted to re-authenticate with the identity provider (IdP) used to enroll in the WARP client.

![WARP client prompts user to re-authenticate session.](https://developers.cloudflare.com/_astro/warp-reauthenticate-session.BjGtdKWz_ZIudhz.webp)

A user's WARP session duration resets to zero whenever they re-authenticate with the IdP, regardless of what triggered the authentication event.

## Configure WARP session timeout

You can enforce WARP session timeouts on any Gateway Network and HTTP policy that has an Allow action. If you do not specify a session timeout, the WARP session will be unlimited by default.

Session timeouts have no impact on Gateway DNS policies. DNS policies remain active even when a user needs to re-authenticate.

To configure a session timeout for a Gateway policy:

* Dashboard

  1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to either **Traffic policies** > **Firewall policies**. Choose either **Network** or **HTTP**.
  2. Add a policy and select the *Allow* action. Alternatively, choose any existing *Allow* policy.
  3. Under **Step 4 - Configure policy settings**, select **Edit** next to **Enforce WARP client session duration**.
  4. Enter a session expiration time in `1h30m0s` format and save.
  5. Save the policy.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Zero Trust Write`

  2. Choose a Network (`l4`) or HTTP (`http`) policy with an Allow action.

  3. In the policy's [`rule_settings`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_gateway_policy), use the `check_session` argument to enable and configure a session timeout:

     ```tf
     resource "cloudflare_zero_trust_gateway_policy" "network_allow_wiki_IPs" {
       name        = "Company Wiki Network policy"
       enabled     = true
       account_id  = var.cloudflare_account_id
       description = "Managed by Terraform - Allow employees to access company wiki IPs."
       precedence  = 103
       action      = "allow"
       filters     = ["l4"]
       traffic     = "net.dst.ip in ${"$"}${cloudflare_zero_trust_list.wiki_IPs.id}"
       identity    = "identity.email matches \".*@example.com\""


       rule_settings = {
         check_session = {
           enforce = true
           duration = "1h30m0s"
         }
       }
     }
     ```

Session checks are now enabled for the application protected by this policy. Users can continue to reach applications outside of the policy definition.

## Global timeouts

To set a global reauthentication event, similar to a global timeout on a traditional VPN, we recommend setting all of your Gateway Network Allow policies to the same baseline WARP session duration (typically between 3-7 days). This will ensure that whenever your user tries to access any application on the private network within that window, they will be forced to reauthenticate with your identity provider when they have not logged in for your chosen number of days.

If a specific application requires a more stringent reauthentication timeline, users accessing that application will not have to complete the baseline reauthentication event because they are already in compliance with the baseline policy.

Note

A global timeout does not necessarily fit all customer needs. With the increased interrogation of traffic offered by ZTNA compared to traditional remote access, many customers choose not to use a global reauthentication event and instead only use reauthentication for specific applications.

### Common mistake

When configuring a global WARP session duration, a common mistake is to build a single policy that covers your entire private network range. An example would be an Allow policy that requires reauthentication every 7 days for all users with traffic to a destination IP in `10.0.0.0/8`. This type of global policy may result in a suboptimal user experience because an expired session blocks the user from the entire internal network (including private DNS functionality) instead of specific applications. If a user misses the one-time reauth notification, they may not know that they need to manually go into their WARP client settings to reauthenticate.
