---
title: How exposed credentials checks work · Cloudflare Web Application Firewall
  (WAF) docs
description: WAF rules can include a check for exposed credentials. When enabled
  in a given rule, exposed credentials checking happens when there is a match
  for the rule expression (that is, the rule expression evaluates to true).
lastUpdated: 2025-09-12T15:50:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/managed-rules/check-for-exposed-credentials/how-checks-work/
  md: https://developers.cloudflare.com/waf/managed-rules/check-for-exposed-credentials/how-checks-work/index.md
---

WAF rules can include a check for exposed credentials. When enabled in a given rule, exposed credentials checking happens when there is a match for the rule expression (that is, the rule expression evaluates to `true`).

At this point, the WAF looks up the username/password pair in the request against a database of publicly available stolen credentials. When both the rule expression and the exposed credentials check are true, there is a rule match, and Cloudflare performs the action configured in the rule.

Recommendation: Use leaked credentials detection instead

Cloudflare recommends that you use [leaked credentials detection](https://developers.cloudflare.com/waf/detections/leaked-credentials/) instead of Cloudflare Exposed Credentials Check, which refers to a previous implementation.\
For more information on upgrading your current Exposed Credentials Check configuration, refer to the [upgrade guide](https://developers.cloudflare.com/waf/managed-rules/check-for-exposed-credentials/upgrade-to-leaked-credentials-detection/).

## Example

For example, the following rule matches `POST` requests to the `/login.php` URI when Cloudflare identifies the submitted credentials as previously exposed:

**Rule #1**

Rule expression:\
`http.request.method == "POST" and http.request.uri == "/login.php"`

Exposed credentials check with the following configuration:

* Username expression: `http.request.body.form["user_id"]`
* Password expression: `http.request.body.form["password"]`

Action: *Interactive Challenge*

When there is a match for the rule above and Cloudflare detects exposed credentials, the WAF presents the user with a challenge.
